<?php
/**
 * Dewata AI Chatbot Uninstall
 *
 * Fired when the plugin is uninstalled/deleted from WordPress.
 * This file is executed when user deletes the plugin from Plugins page.
 *
 * @package Dewata_AI_Chatbot
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Security check - make sure we're uninstalling this plugin
if (!current_user_can('delete_plugins')) {
    exit;
}

// Remove all plugin options from database
delete_option('dewata_chatbot_api_key');
delete_option('dewata_chatbot_exclude_pages');
delete_option('dewata_chatbot_show_on_home');
delete_option('dewata_chatbot_show_on_posts');
delete_option('dewata_chatbot_show_on_pages');
delete_option('dewata_chatbot_show_on_archives');

// For multisite - clean up all sites
if (is_multisite()) {
    global $wpdb;
    $blog_ids = $wpdb->get_col("SELECT blog_id FROM {$wpdb->blogs}");
    
    foreach ($blog_ids as $blog_id) {
        switch_to_blog($blog_id);
        
        delete_option('dewata_chatbot_api_key');
        delete_option('dewata_chatbot_exclude_pages');
        delete_option('dewata_chatbot_show_on_home');
        delete_option('dewata_chatbot_show_on_posts');
        delete_option('dewata_chatbot_show_on_pages');
        delete_option('dewata_chatbot_show_on_archives');
        
        restore_current_blog();
    }
}
